/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pervasive.database.PsqlException;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NavigationBar;
import pvideoj.utils.NumericOnlyDocument;

class ContractInfoView
extends JPanel {
    private JTextField _numberTF;
    private JTextField _dateTF;
    private JTextField _clerkTF;
    private ContractList _contracts;
    private Contract _contract;

    ContractInfoView(ContractList contractList) {
        this._contracts = contractList;
        this.setBorder(new TitledBorder(new EtchedBorder(), "Contract Information"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Number");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 10);
        this.add(jLabel);
        jLabel = new JLabel("Date");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 10);
        this.add(jLabel);
        jLabel = new JLabel("Clerk");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 3, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(jLabel);
        this._numberTF = new JTextField(new NumericOnlyDocument(5), "", 5);
        LayoutUtils.constrain(gridBagConstraints, this, this._numberTF, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 10);
        this.add(this._numberTF);
        JButton jButton = new JButton("Find");
        LayoutUtils.constrain(gridBagConstraints, this, jButton, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 15);
        this.add(jButton);
        jButton.addActionListener(new FindActionListener());
        this._dateTF = new JTextField(8);
        LayoutUtils.constrain(gridBagConstraints, this, this._dateTF, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 10);
        this.add(this._dateTF);
        this._clerkTF = new JTextField(5);
        LayoutUtils.constrain(gridBagConstraints, this, this._clerkTF, 3, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
        this.add(this._clerkTF);
        NavigationBar navigationBar = new NavigationBar(contractList);
        LayoutUtils.constrain(gridBagConstraints, this, navigationBar, 4, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
        this.add(navigationBar);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 5, 0, 1, 2, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
        this._contracts.addDBListSelectionListener(new DBListSelectionListener(){

            @Override
            public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                Contract contract = (Contract)dBListSelectionEvent.getSelectedObject();
                ContractInfoView.this.setContract(contract != null ? contract : ContractInfoView.this._contracts.createContract());
            }
        });
    }

    public boolean isValidInput() {
        if (this._clerkTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._clerkTF, "Missing clerk data.");
            return false;
        }
        try {
            DateFormat.getDateInstance(3).parse(this._dateTF.getText());
        }
        catch (ParseException parseException) {
            ErrorMessage.showMessage((Component)this._dateTF, "Invalid date format");
            return false;
        }
        if (this._numberTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._numberTF, "Missing contract number");
            return false;
        }
        return true;
    }

    public void setContract(Contract contract) {
        this._contract = contract;
        this._numberTF.setText(String.valueOf(this._contract.getID()));
        this._clerkTF.setText(this._contract.getEmployeeInitials());
        this._dateTF.setText(DateFormat.getDateInstance(3).format(contract.getDate()));
    }

    public Contract getContract() {
        try {
            this._contract.setDate(DateFormat.getDateInstance(3).parse(this._dateTF.getText()));
        }
        catch (ParseException parseException) {
            ErrorMessage.showMessage((Component)this, "Invalid date format");
            return null;
        }
        this._contract.setID(Integer.parseInt(this._numberTF.getText()));
        this._contract.setEmployeeInitials(this._clerkTF.getText());
        return this._contract;
    }

    class FindActionListener
    implements ActionListener {
        FindActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Contract contract = null;
            try {
                int n = Integer.parseInt(ContractInfoView.this._numberTF.getText());
                contract = ContractInfoView.this._contracts.findContract(n);
                if (contract == null) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, "Contract \"" + n + "\" not found.");
                    return;
                }
                ContractInfoView.this._contracts.setSelectionIndex(ContractInfoView.this._contracts.getCurrentIndex());
            }
            catch (PsqlException psqlException) {
                ErrorMessage.showMessage((Component)actionEvent.getSource(), (Exception)((Object)psqlException));
            }
        }
    }
}

