/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import pervasive.database.PsqlException;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.ContractTitleList;
import pvideoj.model.CustomerList;
import pvideoj.model.PVideoDB;
import pvideoj.model.TitleCopyList;
import pvideoj.model.TitleList;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.InfoActionArea;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.ContractInfoView;
import pvideoj.views.CustomerInfoView;
import pvideoj.views.TitlesRentedView;

class ContractView
extends JPanel
implements ActionListener {
    private static final String[] _actionToolTips = new String[]{"Create a new contract", "Save current contract", "Delete current contract", "Reset current contract to original values", "Close Contracts Dialog"};
    private ContractInfoView _contractInfoView;
    private CustomerInfoView _customerInfoView;
    private TitlesRentedView _titlesRentedView;
    private InfoActionArea _infoActionArea;
    private ContractList _contracts;
    private ContractTitleList _contractTitles;
    private CustomerList _customers;
    private TitleList _titles;
    private TitleCopyList _titleCopies;
    private int _restore_index = -1;

    ContractView() throws PsqlException {
        PVideoDB pVideoDB = PVideoDB.instance();
        this._contracts = (ContractList)pVideoDB.getSharedDBObjectList(1);
        this._contractTitles = (ContractTitleList)pVideoDB.getSharedDBObjectList(2);
        this._contractTitles.setRestrictOnSelectedContract(this._contracts);
        this._customers = (CustomerList)pVideoDB.createDBObjectList(3);
        this._titles = (TitleList)pVideoDB.createDBObjectList(7);
        this._titleCopies = (TitleCopyList)pVideoDB.createDBObjectList(6);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._contractInfoView = new ContractInfoView(this._contracts);
        LayoutUtils.constrain(gridBagConstraints, this, this._contractInfoView, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._contractInfoView);
        this._customerInfoView = new CustomerInfoView(this._contracts, this._customers);
        LayoutUtils.constrain(gridBagConstraints, this, this._customerInfoView, 0, 1, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._customerInfoView);
        this._titlesRentedView = new TitlesRentedView(this._contracts, this._contractTitles, this._titles, this._titleCopies);
        LayoutUtils.constrain(gridBagConstraints, this, this._titlesRentedView, 0, 2, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(this._titlesRentedView);
        this._infoActionArea = new InfoActionArea();
        this._infoActionArea.setToolTips(_actionToolTips);
        LayoutUtils.constrain(gridBagConstraints, this, this._infoActionArea, 0, 3, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._infoActionArea);
        this._infoActionArea.addActionListener(this);
        if (this._contracts.getRowCount() > 0) {
            this._contracts.setSelectionIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Contract contract = null;
        switch (this._infoActionArea.getButton(actionEvent.getActionCommand())) {
            case 0: {
                this._restore_index = this._contracts.getSelectedIndex();
                this._contracts.clearSelection();
                this._infoActionArea.setEnabled(2, false);
                break;
            }
            case 1: {
                if (!this._contractInfoView.isValidInput() || !this._customerInfoView.isValidInput()) {
                    return;
                }
                try {
                    contract = this._contractInfoView.getContract();
                    int n = contract.getID();
                    int n2 = this._customerInfoView.getCustomer().getID();
                    if (this._customers.findCustomerByIndex(n2) == null) {
                        ErrorMessage.showMessage((Component)this._customerInfoView, "Customer \"" + n2 + "\"not found.");
                        return;
                    }
                    contract.setCustomerID(n2);
                    try {
                        PVideoDB.instance().getSession().startTransaction(0);
                        boolean bl = contract.isNew();
                        this._contracts.save(contract);
                        if (bl) {
                            if (n == 0) {
                                n = ((Contract)this._contracts.getLast()).getID();
                            }
                            this._titlesRentedView.getTableModel().setContractID(n);
                        }
                        this._titlesRentedView.getTableModel().saveRows();
                        PVideoDB.instance().getSession().commitTransaction();
                    }
                    catch (PsqlException psqlException) {
                        ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                        try {
                            PVideoDB.instance().getSession().abortTransaction();
                        }
                        catch (PsqlException psqlException2) {
                            ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException2));
                        }
                    }
                    this._contracts.findContract(n);
                    this._contracts.setSelectionIndex(this._contracts.getCurrentIndex());
                    this._infoActionArea.setEnabled(2, true);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
                break;
            }
            case 2: {
                contract = (Contract)this._contracts.getSelectedObject();
                if (contract == null) break;
                boolean bl = this._contracts.isSelectedLast();
                int n = this._contracts.getSelectedIndex();
                try {
                    PVideoDB.instance().getSession().startTransaction(0);
                    this._contracts.delete(contract);
                    this._contractTitles.deleteAll();
                    PVideoDB.instance().getSession().commitTransaction();
                    if (!bl) {
                        this._contracts.setSelectionIndex(n);
                        break;
                    }
                    this._contracts.setSelectionIndex(n - 1);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                    try {
                        PVideoDB.instance().getSession().abortTransaction();
                    }
                    catch (PsqlException psqlException3) {
                        ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException3));
                    }
                }
                break;
            }
            case 3: {
                this._contracts.setSelectionIndex(this._restore_index != -1 ? this._restore_index : this._contracts.getSelectedIndex());
                this._restore_index = -1;
                this._infoActionArea.setEnabled(2, true);
                break;
            }
            case 4: {
                this.getTopLevelAncestor().setVisible(false);
            }
        }
    }
}

