/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import pvideoj.model.Customer;
import pvideoj.model.CustomerList;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObject;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.AddressPanel;
import pvideoj.views.CardPanel;
import pvideoj.views.NamePanel;
import pvideoj.views.PhonePanel;
import pvideoj.views.StatusPanel;

class CustomerView
extends JPanel {
    private CardPanel _cardPanel;
    private NamePanel _namePanel;
    private AddressPanel _addressPanel;
    private PhonePanel _phonePanel;
    private StatusPanel _statusPanel;
    private CustomerList _customers;
    private Customer _customer;

    public CustomerView(CustomerList customerList) {
        this._customers = customerList;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._cardPanel = new CardPanel("Card Information", customerList);
        LayoutUtils.constrain(gridBagConstraints, this, this._cardPanel, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._cardPanel);
        this._namePanel = new NamePanel("Name");
        LayoutUtils.constrain(gridBagConstraints, this, this._namePanel, 0, 1, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._namePanel);
        this._addressPanel = new AddressPanel("Address");
        LayoutUtils.constrain(gridBagConstraints, this, this._addressPanel, 0, 2, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._addressPanel);
        this._phonePanel = new PhonePanel("Phone");
        LayoutUtils.constrain(gridBagConstraints, this, this._phonePanel, 0, 3, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._phonePanel);
        this._statusPanel = new StatusPanel("Status");
        LayoutUtils.constrain(gridBagConstraints, this, this._statusPanel, 0, 4, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._statusPanel);
        this._customers.addDBListSelectionListener(new DBListSelectionListener(){

            @Override
            public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                DBObject dBObject = dBListSelectionEvent.getSelectedObject();
                if (dBObject == null) {
                    dBObject = CustomerView.this._customers.createCustomer();
                }
                CustomerView.this.setCustomer((Customer)dBObject);
            }
        });
    }

    public void setCustomer(Customer customer) {
        this._customer = customer;
        this._cardPanel.setCardNumber(this._customer.getID());
        this._namePanel.setLastName(this._customer.getLastName());
        this._namePanel.setFirstName(this._customer.getFirstName());
        this._addressPanel.setStreet1(this._customer.getAddress1());
        this._addressPanel.setStreet2(this._customer.getAddress2());
        this._addressPanel.setCity(this._customer.getCity());
        this._addressPanel.setState(this._customer.getState());
        this._addressPanel.setZip(this._customer.getZip());
        this._phonePanel.setHomePhone(this._customer.getHomePhone());
        this._phonePanel.setWorkPhone(this._customer.getWorkPhone());
        this._statusPanel.setStatus(this._customer.getStatus());
        this._statusPanel.setClubMember(this._customer.isMember());
        this._statusPanel.setExpiration(this._customer.getExpiration());
    }

    public Customer getCustomer() {
        this._customer.setID(this._cardPanel.getCardNumber());
        this._customer.setLastName(this._namePanel.getLastName());
        this._customer.setFirstName(this._namePanel.getFirstName());
        this._customer.setAddress1(this._addressPanel.getStreet1());
        this._customer.setAddress2(this._addressPanel.getStreet2());
        this._customer.setCity(this._addressPanel.getCity());
        this._customer.setState(this._addressPanel.getState());
        this._customer.setZip(this._addressPanel.getZip());
        this._customer.setHomePhone(this._phonePanel.getHomePhone());
        this._customer.setWorkPhone(this._phonePanel.getWorkPhone());
        this._customer.setStatus(this._statusPanel.getStatus());
        this._customer.setMember(this._statusPanel.isClubMember());
        this._customer.setExpiration(this._statusPanel.getExpiration());
        return this._customer;
    }

    public boolean isValidInput() {
        return this._cardPanel.isValidInput() && this._namePanel.isValidInput() && this._addressPanel.isValidInput() && this._phonePanel.isValidInput() && this._statusPanel.isValidInput();
    }
}

