/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import pervasive.database.PsqlException;
import pvideoj.model.Employee;
import pvideoj.model.EmployeeList;
import pvideoj.model.ListTableModelAdapter;
import pvideoj.model.PVideoDB;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.InfoActionArea;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NavigationBar;
import pvideoj.views.EmployeeView;
import pvideoj.views.ListTableView;

class EmployeePanel
extends JPanel
implements ActionListener {
    private static String[] _columnHeadings = new String[]{"Initials", "Last Name", "First Name"};
    private static String[] _columnNames = new String[]{"Initials", "LastName", "FirstName"};
    private static final String[] _actionToolTips = new String[]{"Create a new employee", "Save current employee", "Delete current employee", "Reset current employee to original values", "Close Employees Dialog"};
    private EmployeeView _employeeView;
    private InfoActionArea _infoActionArea;
    private EmployeeList _employees = (EmployeeList)PVideoDB.instance().getSharedDBObjectList(4);
    private int _restore_index = -1;

    public EmployeePanel() throws PsqlException {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ListTableModelAdapter listTableModelAdapter = new ListTableModelAdapter(this._employees, _columnHeadings, _columnNames);
        ListTableView listTableView = new ListTableView(this._employees, listTableModelAdapter, _columnHeadings, _columnNames, new Dimension(200, 1), "Listing");
        LayoutUtils.constrain(gridBagConstraints, this, listTableView, 0, 0, 1, 2, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(listTableView);
        this._employeeView = new EmployeeView(this._employees);
        LayoutUtils.constrain(gridBagConstraints, this, this._employeeView, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.add(this._employeeView);
        NavigationBar navigationBar = new NavigationBar(this._employees);
        LayoutUtils.constrain(gridBagConstraints, this, navigationBar, 1, 1, 1, 1, 0, 11, 0.0, 0.0, 0, 0, 0, 0);
        this.add(navigationBar);
        this._infoActionArea = new InfoActionArea();
        this._infoActionArea.setToolTips(_actionToolTips);
        LayoutUtils.constrain(gridBagConstraints, this, this._infoActionArea, 0, 2, 2, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._infoActionArea);
        this._infoActionArea.addActionListener(this);
        if (this._employees.getRowCount() > 0) {
            this._employees.setSelectionIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Employee employee = null;
        switch (this._infoActionArea.getButton(actionEvent.getActionCommand())) {
            case 0: {
                this._restore_index = this._employees.getSelectedIndex();
                this._employeeView.setEmployee(this._employees.createEmployee());
                this._infoActionArea.setEnabled(2, false);
                break;
            }
            case 1: {
                if (!this._employeeView.isValidInput()) {
                    return;
                }
                employee = this._employeeView.getEmployee();
                if (employee == null) break;
                try {
                    this._employees.save(employee);
                    this._employees.findEmployee(employee.getInitials());
                    this._employees.setSelectionIndex(this._employees.getCurrentIndex());
                    this._infoActionArea.setEnabled(2, true);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
                break;
            }
            case 2: {
                employee = (Employee)this._employees.getSelectedObject();
                if (employee == null) break;
                try {
                    boolean bl = this._employees.isSelectedLast();
                    int n = this._employees.getSelectedIndex();
                    this._employees.delete(employee);
                    if (!bl) {
                        this._employees.setSelectionIndex(n);
                        break;
                    }
                    this._employees.setSelectionIndex(n - 1);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
                break;
            }
            case 3: {
                this._employees.setSelectionIndex(this._restore_index != -1 ? this._restore_index : this._employees.getSelectedIndex());
                this._restore_index = -1;
                this._infoActionArea.setEnabled(2, true);
                break;
            }
            case 4: {
                this.getTopLevelAncestor().setVisible(false);
            }
        }
    }
}

