/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObject;
import pvideoj.model.Employee;
import pvideoj.model.EmployeeList;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.AddressPanel;
import pvideoj.views.EmployeeIDPanel;
import pvideoj.views.NamePanel;

class EmployeeView
extends JPanel {
    private EmployeeIDPanel _idPanel;
    private NamePanel _namePanel;
    private AddressPanel _addressPanel;
    private EmployeeList _employees;
    private Employee _employee;

    public EmployeeView(EmployeeList employeeList) {
        this._employees = employeeList;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._idPanel = new EmployeeIDPanel(employeeList);
        LayoutUtils.constrain(gridBagConstraints, this, this._idPanel, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._idPanel);
        this._namePanel = new NamePanel("Name");
        LayoutUtils.constrain(gridBagConstraints, this, this._namePanel, 0, 1, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._namePanel);
        this._addressPanel = new AddressPanel("Address");
        LayoutUtils.constrain(gridBagConstraints, this, this._addressPanel, 0, 2, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._addressPanel);
        this._employees.addDBListSelectionListener(new DBListSelectionListener(){

            @Override
            public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                DBObject dBObject = dBListSelectionEvent.getSelectedObject();
                if (dBObject == null) {
                    dBObject = EmployeeView.this._employees.createEmployee();
                }
                EmployeeView.this.setEmployee((Employee)dBObject);
            }
        });
    }

    public void setEmployee(Employee employee) {
        this._employee = employee;
        this._idPanel.setInitials(employee.getInitials());
        this._idPanel.setSSN(employee.getSSN());
        this._namePanel.setLastName(employee.getLastName());
        this._namePanel.setFirstName(employee.getFirstName());
        this._addressPanel.setStreet1(employee.getAddress1());
        this._addressPanel.setStreet2(employee.getAddress2());
        this._addressPanel.setCity(employee.getCity());
        this._addressPanel.setState(employee.getState());
        this._addressPanel.setZip(employee.getZip());
    }

    public Employee getEmployee() {
        this._employee.setInitials(this._idPanel.getInitials());
        this._employee.setSSN(this._idPanel.getSSN());
        this._employee.setLastName(this._namePanel.getLastName());
        this._employee.setFirstName(this._namePanel.getFirstName());
        this._employee.setAddress1(this._addressPanel.getStreet1());
        this._employee.setAddress2(this._addressPanel.getStreet2());
        this._employee.setCity(this._addressPanel.getCity());
        this._employee.setState(this._addressPanel.getState());
        this._employee.setZip(this._addressPanel.getZip());
        return this._employee;
    }

    boolean isValidInput() {
        return this._idPanel.isValidInput() && this._namePanel.isValidInput() && this._addressPanel.isValidInput();
    }
}

