/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.MaxLengthDocument;

public class PhonePanel
extends JPanel {
    private JTextField _homeTF;
    private JTextField _workTF;

    public PhonePanel(String string) {
        this.setBorder(new TitledBorder(new EtchedBorder(), string));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Home");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 2, 5);
        this.add(jLabel);
        jLabel = new JLabel("Work");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 2, 5);
        this.add(jLabel);
        this._homeTF = new JTextField(new MaxLengthDocument(13), "", 12);
        LayoutUtils.constrain(gridBagConstraints, this, this._homeTF, 0, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 5, 3, 5);
        this.add(this._homeTF);
        this._workTF = new JTextField(new MaxLengthDocument(13), "", 12);
        LayoutUtils.constrain(gridBagConstraints, this, this._workTF, 1, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 3, 5);
        this.add(this._workTF);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 2, 0, 1, 2, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    public boolean isValidInput() {
        if (this._homeTF.getText().length() < 8) {
            ErrorMessage.showMessage((Component)this._homeTF, "Invalid home phone number.");
            return false;
        }
        if (this._workTF.getText().length() < 8) {
            ErrorMessage.showMessage((Component)this._workTF, "Invalid work phone number.");
            return false;
        }
        return true;
    }

    public void setEditable(boolean bl) {
        this._homeTF.setEditable(bl);
        this._workTF.setEditable(bl);
    }

    public void setHomePhone(String string) {
        this._homeTF.setText(string);
    }

    public String getHomePhone() {
        return this._homeTF.getText();
    }

    public void setWorkPhone(String string) {
        this._workTF.setText(string);
    }

    public String getWorkPhone() {
        return this._workTF.getText();
    }
}

