/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.MaxLengthDocument;

public class StatusPanel
extends JPanel {
    private static String[] _status_labels = new String[]{"Green", "Red", "Yellow"};
    private static String[] _allowedStrs = new String[]{"10", "0", "2"};
    private JCheckBox _club_ckb;
    private JRadioButton[] _status_rbs;
    private JTextField _expirationTF;
    private JTextField _allowedTF;
    private boolean _editable;

    StatusPanel(String string) {
        this.setBorder(new TitledBorder(new EtchedBorder(), string));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._club_ckb = new JCheckBox("Premium Club Member");
        LayoutUtils.constrain(gridBagConstraints, this, this._club_ckb, 0, 0, 3, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(this._club_ckb);
        JLabel jLabel = new JLabel("Expiration");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 3, 0, 1, 1, 0, 13, 0.0, 0.0, 5, 5, 0, 5);
        this.add(jLabel);
        this._expirationTF = new JTextField(new MaxLengthDocument(8), "", 5);
        LayoutUtils.constrain(gridBagConstraints, this, this._expirationTF, 4, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(this._expirationTF);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._status_rbs = new JRadioButton[_status_labels.length];
        StatusActionListener statusActionListener = new StatusActionListener();
        for (int i = 0; i < _status_labels.length; ++i) {
            this._status_rbs[i] = new JRadioButton(_status_labels[i]);
            this._status_rbs[i].setActionCommand(String.valueOf(i));
            LayoutUtils.constrain(gridBagConstraints, this, this._status_rbs[i], i, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
            this.add(this._status_rbs[i]);
            buttonGroup.add(this._status_rbs[i]);
            this._status_rbs[i].addActionListener(statusActionListener);
        }
        jLabel = new JLabel("Titles Allowed");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 3, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(jLabel);
        this._allowedTF = new JTextField(2);
        LayoutUtils.constrain(gridBagConstraints, this, this._allowedTF, 4, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(this._allowedTF);
        this._allowedTF.setHorizontalAlignment(4);
        this._allowedTF.setEditable(false);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 5, 0, 1, 2, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    public boolean isValidInput() {
        if (!this.isClubMember()) {
            return true;
        }
        String string = this._expirationTF.getText();
        if (this._expirationTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._expirationTF, "Missing expiration date.");
            return false;
        }
        try {
            Date date = DateFormat.getDateInstance(3).parse(string);
        }
        catch (ParseException parseException) {
            ErrorMessage.showMessage((Component)this._expirationTF, "Invalid expiration date.");
            return false;
        }
        return true;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        this._expirationTF.setEditable(bl);
    }

    public void setStatus(int n) {
        this._status_rbs[n].setSelected(true);
        this._allowedTF.setText(_allowedStrs[n]);
    }

    public int getStatus() {
        for (int i = 0; i < this._status_rbs.length; ++i) {
            if (!this._status_rbs[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void setClubMember(boolean bl) {
        this._club_ckb.setSelected(bl);
    }

    public boolean isClubMember() {
        return this._club_ckb.isSelected();
    }

    public void setExpiration(Date date) {
        if (!this.isClubMember()) {
            date = null;
        }
        this._expirationTF.setText(date == null ? "" : DateFormat.getDateInstance(3).format(date));
    }

    public Date getExpiration() {
        if (!this.isClubMember()) {
            return new Date();
        }
        String string = this._expirationTF.getText();
        Date date = null;
        try {
            date = DateFormat.getDateInstance(3).parse(string);
        }
        catch (ParseException parseException) {
            ErrorMessage.showMessage((Component)this._expirationTF, (Exception)parseException);
        }
        return date;
    }

    class StatusActionListener
    implements ActionListener {
        StatusActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusPanel.this._allowedTF.setText(_allowedStrs[Integer.parseInt(actionEvent.getActionCommand())]);
        }
    }
}

