/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import pervasive.database.PsqlException;
import pvideoj.model.ContractTitle;
import pvideoj.model.ContractTitleList;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListModelListener;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.PVideoDB;
import pvideoj.model.TitleCopiesTableModel;
import pvideoj.model.TitleCopy;
import pvideoj.model.TitleCopyList;
import pvideoj.model.TitleList;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NumericOnlyDocument;
import pvideoj.views.TitleCopiesTableView;

class TitleCopiesPanel
extends JPanel {
    private static String[] _copyColumnHeadings = new String[]{"Copy", "Status"};
    private static String[] _copyColumnNames = new String[]{"Copy", "Status"};
    private TitleCopyList _copies;
    private TitleList _titles;
    private ContractTitleList _contract_titles;

    TitleCopiesPanel() throws PsqlException {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Selected Title's Copies"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PVideoDB pVideoDB = PVideoDB.instance();
        this._copies = (TitleCopyList)pVideoDB.getSharedDBObjectList(6);
        this._titles = (TitleList)pVideoDB.getSharedDBObjectList(7);
        this._copies.setRestrictOnSelectedTitle(this._titles);
        this._contract_titles = (ContractTitleList)pVideoDB.createDBObjectList(2);
        TitleCopiesTableModel titleCopiesTableModel = new TitleCopiesTableModel(this._copies, _copyColumnHeadings, _copyColumnNames);
        TitleCopiesTableView titleCopiesTableView = new TitleCopiesTableView(this._copies, (TableModel)titleCopiesTableModel, _copyColumnHeadings, _copyColumnNames, new Dimension(400, 100), "Copy List");
        LayoutUtils.constrain(gridBagConstraints, this, titleCopiesTableView, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(titleCopiesTableView);
        TitleCopiesActions titleCopiesActions = new TitleCopiesActions();
        LayoutUtils.constrain(gridBagConstraints, this, titleCopiesActions, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.add(titleCopiesActions);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 2, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    class TitleCopiesActions
    extends JPanel {
        private JTextField _num_copies_tf;
        private JButton _deleteBtn;
        private JButton _newBtn;

        TitleCopiesActions() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this._newBtn = new JButton("New");
            this._newBtn.setEnabled(false);
            LayoutUtils.constrain(gridBagConstraints, this, this._newBtn, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 10, 5, 10);
            this.add(this._newBtn);
            this._newBtn.setToolTipText("Add # of copies");
            this._newBtn.addActionListener(new NewCopyListener());
            JLabel jLabel = new JLabel("# of copies");
            LayoutUtils.constrain(gridBagConstraints, this, jLabel, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 5);
            this.add(jLabel);
            this._num_copies_tf = new JTextField(new NumericOnlyDocument(2), "1", 2);
            LayoutUtils.constrain(gridBagConstraints, this, this._num_copies_tf, 2, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
            this.add(this._num_copies_tf);
            this._deleteBtn = new JButton("Delete");
            this._deleteBtn.setEnabled(false);
            LayoutUtils.constrain(gridBagConstraints, this, this._deleteBtn, 0, 1, 1, 1, 2, 10, 1.0, 0.0, 0, 10, 5, 10);
            this.add(this._deleteBtn);
            this._deleteBtn.setToolTipText("Delete the selected copy");
            this._deleteBtn.addActionListener(new DeleteCopyListener());
            TitleCopiesPanel.this._copies.addDBListSelectionListener(new DBListSelectionListener(){

                @Override
                public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                    TitleCopiesActions.this._deleteBtn.setEnabled(dBListSelectionEvent.getSelectedRowIndex() != -1);
                }
            });
            TitleCopiesPanel.this._copies.addDBListModelListener(new DBListModelListener(){

                @Override
                public void listChanged(DBListModelEvent dBListModelEvent) {
                    if (dBListModelEvent.getType() == -1) {
                        TitleCopiesActions.this._deleteBtn.setEnabled(false);
                    }
                }
            });
            TitleCopiesPanel.this._titles.addDBListSelectionListener(new DBListSelectionListener(){

                @Override
                public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                    TitleCopiesActions.this._newBtn.setEnabled(dBListSelectionEvent.getSelectedRowIndex() != -1);
                }
            });
        }

        class DeleteCopyListener
        implements ActionListener {
            DeleteCopyListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = TitleCopiesPanel.this._copies.getSelectedIndex();
                    boolean bl = TitleCopiesPanel.this._copies.isSelectedLast();
                    TitleCopy titleCopy = (TitleCopy)TitleCopiesPanel.this._copies.getSelectedObject();
                    ContractTitle contractTitle = TitleCopiesPanel.this._contract_titles.findContractTitleByIndex(titleCopy.getTitleID(), titleCopy.getCopy());
                    if (contractTitle != null) {
                        String string = "Cannot delete this copy.\n";
                        string = string + "It is referenced in contract \"" + contractTitle.getContractID() + "\".";
                        ErrorMessage.showMessage((AWTEvent)actionEvent, string);
                        return;
                    }
                    TitleCopiesPanel.this._copies.delete(TitleCopiesPanel.this._copies.getSelectedObject());
                    if (!bl) {
                        TitleCopiesPanel.this._copies.setSelectionIndex(n);
                    } else {
                        TitleCopiesPanel.this._copies.setSelectionIndex(n - 1);
                    }
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
            }
        }

        class NewCopyListener
        implements ActionListener {
            NewCopyListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = Integer.parseInt(((TitleCopiesPanel)TitleCopiesPanel.this)._copies.getRestriction().value);
                int n2 = 1;
                try {
                    object = (TitleCopy)TitleCopiesPanel.this._copies.getLast();
                    if (object != null) {
                        n2 = ((TitleCopy)object).getCopy() + 1;
                    }
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                    return;
                }
                object = TitleCopiesActions.this._num_copies_tf.getText();
                if (((String)object).length() == 0) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, "Invalid number of copies.");
                    return;
                }
                int n3 = Integer.parseInt((String)object);
                for (int i = 0; i < n3; ++i) {
                    TitleCopy titleCopy = TitleCopiesPanel.this._copies.createTitleCopy();
                    titleCopy.setTitleID(n);
                    titleCopy.setCopy(n2++);
                    titleCopy.setStatus(0);
                    try {
                        TitleCopiesPanel.this._copies.save(titleCopy);
                        continue;
                    }
                    catch (PsqlException psqlException) {
                        ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                    }
                }
                try {
                    TitleCopiesPanel.this._copies.getLast();
                    TitleCopiesPanel.this._copies.setSelectionIndex(TitleCopiesPanel.this._copies.getCurrentIndex());
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
            }
        }
    }
}

