/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pervasive.database.PsqlException;
import pvideoj.model.ContractList;
import pvideoj.model.ContractTitleList;
import pvideoj.model.TitleCopy;
import pvideoj.model.TitleCopyList;
import pvideoj.model.TitleList;
import pvideoj.model.TitlesRentedTableModel;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NumericOnlyDocument;
import pvideoj.views.ContractTitlesTableView;

class TitlesRentedView
extends JPanel {
    private static String[] _columnHeadings = new String[]{"Number", "Title", "Price", "Date Due"};
    private JTextField _numberTF;
    private JTextField _copyTF;
    private JButton _addBtn;
    private JButton _deleteBtn;
    private TitlesRentedTableModel _tableModel;
    private TitleList _titles;
    private TitleCopyList _titleCopies;
    private int _selectedIndex = -1;

    TitlesRentedView(ContractList contractList, ContractTitleList contractTitleList, TitleList titleList, TitleCopyList titleCopyList) {
        this._titles = titleList;
        this._titleCopies = titleCopyList;
        this.setBorder(new TitledBorder(new EtchedBorder(), "Titles Rented"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Number");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 3);
        this.add(jLabel);
        jLabel = new JLabel("Copy");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 3, 0, 5);
        this.add(jLabel);
        this._numberTF = new JTextField(new NumericOnlyDocument(5), "", 4);
        LayoutUtils.constrain(gridBagConstraints, this, this._numberTF, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 3);
        this.add(this._numberTF);
        this._numberTF.getDocument().addDocumentListener(new TextFieldDocumentListener());
        jLabel = new JLabel("-");
        jLabel.setFont(new Font("Monospaced", 0, 20));
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 1, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.add(jLabel);
        this._copyTF = new JTextField(new NumericOnlyDocument(2), "", 2);
        LayoutUtils.constrain(gridBagConstraints, this, this._copyTF, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 3, 5, 5);
        this.add(this._copyTF);
        this._copyTF.getDocument().addDocumentListener(new TextFieldDocumentListener());
        this._addBtn = new JButton("Add");
        LayoutUtils.constrain(gridBagConstraints, this, this._addBtn, 3, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 15);
        this.add(this._addBtn);
        this._addBtn.setToolTipText("Add title to list");
        this._addBtn.setEnabled(false);
        this._addBtn.addActionListener(new AddTitleActionListener());
        this._deleteBtn = new JButton("Delete");
        this._deleteBtn.setToolTipText("Delete title from list");
        LayoutUtils.constrain(gridBagConstraints, this, this._deleteBtn, 4, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 15);
        this.add(this._deleteBtn);
        this._deleteBtn.setEnabled(false);
        this._deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TitlesRentedView.this._selectedIndex != -1) {
                    TitlesRentedView.this._tableModel.deleteRow(TitlesRentedView.this._selectedIndex);
                }
            }
        });
        this._tableModel = new TitlesRentedTableModel(contractList, contractTitleList, titleList, _columnHeadings);
        final ContractTitlesTableView contractTitlesTableView = new ContractTitlesTableView(contractTitleList, this._tableModel, _columnHeadings, new Dimension(1, 50), "Contract Titles");
        contractTitlesTableView.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (contractTitlesTableView.isRowSelected(listSelectionEvent.getFirstIndex())) {
                    TitlesRentedView.this._deleteBtn.setEnabled(true);
                    TitlesRentedView.this._selectedIndex = listSelectionEvent.getFirstIndex();
                } else {
                    TitlesRentedView.this._deleteBtn.setEnabled(false);
                    TitlesRentedView.this._selectedIndex = -1;
                }
            }
        });
        LayoutUtils.constrain(gridBagConstraints, this, contractTitlesTableView, 0, 2, 5, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(contractTitlesTableView);
    }

    TitlesRentedTableModel getTableModel() {
        return this._tableModel;
    }

    void setEnabledTitleAddButton() {
        if (this._numberTF.getDocument().getLength() > 0 && this._copyTF.getDocument().getLength() > 0) {
            this._addBtn.setEnabled(true);
        } else {
            this._addBtn.setEnabled(false);
        }
    }

    class TextFieldDocumentListener
    implements DocumentListener {
        TextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            TitlesRentedView.this.setEnabledTitleAddButton();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TitlesRentedView.this.setEnabledTitleAddButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TitlesRentedView.this.setEnabledTitleAddButton();
        }
    }

    class AddTitleActionListener
    implements ActionListener {
        AddTitleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(TitlesRentedView.this._numberTF.getText());
            int n2 = Integer.parseInt(TitlesRentedView.this._copyTF.getText());
            try {
                TitleCopy titleCopy = TitlesRentedView.this._titleCopies.findTitleCopyByIndex(n, n2);
                if (titleCopy == null) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, "Title\"" + n + "\"" + " copy \"" + n2 + "\" not found.");
                    return;
                }
                if (titleCopy.getStatus() != 0) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, "Title copy status is \"" + TitlesRentedView.this._titleCopies.getStatusStr(titleCopy.getStatus()) + "\".");
                    return;
                }
                TitlesRentedView.this._tableModel.addRow(n, n2);
                TitlesRentedView.this._numberTF.setText("");
                TitlesRentedView.this._copyTF.setText("");
            }
            catch (PsqlException psqlException) {
                ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
            }
        }
    }
}

