/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pervasive.database.PsqlException;
import pvideoj.model.Employee;
import pvideoj.model.EmployeeList;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.LetterOnlyDocument;
import pvideoj.utils.MaxLengthDocument;

class EmployeeIDPanel
extends JPanel {
    private JTextField _initialsTF;
    private JTextField _ssnTF;
    EmployeeList _employees;

    public EmployeeIDPanel(EmployeeList employeeList) {
        this._employees = employeeList;
        this.setBorder(new TitledBorder(new EtchedBorder(), "Identification"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Initials");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 10);
        this.add(jLabel);
        jLabel = new JLabel("SSN");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 5);
        this.add(jLabel);
        int n = this._employees.getColumnWidth("Initials");
        this._initialsTF = new JTextField(new LetterOnlyDocument(n), "", n);
        LayoutUtils.constrain(gridBagConstraints, this, this._initialsTF, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 10);
        this.add(this._initialsTF);
        JButton jButton = new JButton("Find");
        LayoutUtils.constrain(gridBagConstraints, this, jButton, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 15);
        this.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = EmployeeIDPanel.this.getInitials();
                try {
                    Employee employee = EmployeeIDPanel.this._employees.findEmployee(string);
                    if (employee == null) {
                        ErrorMessage.showMessage((AWTEvent)actionEvent, "Employee \"" + string + "\" not found.");
                        return;
                    }
                    EmployeeIDPanel.this._employees.setSelectionIndex(EmployeeIDPanel.this._employees.getCurrentIndex());
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
            }
        });
        n = this._employees.getColumnWidth("SSN");
        this._ssnTF = new JTextField(new MaxLengthDocument(n), null, n);
        LayoutUtils.constrain(gridBagConstraints, this, this._ssnTF, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
        this.add(this._ssnTF);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 3, 0, 1, 2, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    public void setInitials(String string) {
        this._initialsTF.setText(string);
    }

    public boolean isValidInput() {
        if (this._initialsTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._initialsTF, "Initials must contain at least 1 character.");
            return false;
        }
        if (this._ssnTF.getText().length() < 11) {
            ErrorMessage.showMessage((Component)this._ssnTF, "Invalid SSN number.");
            return false;
        }
        return true;
    }

    public String getInitials() {
        return this._initialsTF.getText();
    }

    public void setSSN(String string) {
        this._ssnTF.setText(string);
    }

    public String getSSN() {
        return this._ssnTF.getText();
    }
}

