/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObjectList;

public class ListTableView
extends JPanel
implements ListSelectionListener,
DBListSelectionListener {
    protected DBObjectList objectList;
    protected String[] columnHeadings;
    protected String[] columnNames;
    protected JTable table;
    protected TableModel tableModel;
    private boolean _externalSelected = false;
    private boolean _internalSelected = false;
    private boolean _adjustScrollBar = false;

    public ListTableView(DBObjectList dBObjectList, TableModel tableModel, String[] stringArray, String[] stringArray2, Dimension dimension, String string) {
        this.objectList = dBObjectList;
        this.tableModel = tableModel;
        this.columnHeadings = stringArray;
        this.columnNames = stringArray2;
        dBObjectList.addDBListSelectionListener(this);
        if (string != null) {
            this.setBorder(new TitledBorder(new EtchedBorder(), string));
        }
        this.setLayout(new BorderLayout());
        this.table = new JTable(tableModel);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setColumnEditor(i);
            this.setColumnWidth(i);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        dimension.width = this.table.getPreferredSize().width;
        this.table.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add("Center", jScrollPane);
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ListTableView.this._adjustScrollBar) {
                    return;
                }
                ListTableView.this._adjustScrollBar = false;
                int n = ListTableView.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                ListTableView.this.table.addRowSelectionInterval(n, n);
                ListTableView.this.table.scrollRectToVisible(ListTableView.this.table.getCellRect(n, 0, true));
            }
        });
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    protected void setColumnEditor(int n) {
    }

    protected void setColumnWidth(int n) {
        this.setWidthToDBColumn(n);
    }

    protected void setWidthToDBColumn(int n) {
        Component component;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            component = this.table.getTableHeader();
            Class<?> clazz = component.getClass();
            try {
                Method method = clazz.getDeclaredMethod("getDefaultRenderer", null);
                tableCellRenderer = (TableCellRenderer)method.invoke((Object)component, null);
            }
            catch (Exception exception) {
                return;
            }
        }
        component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n2 = component.getPreferredSize().width;
        int n3 = this.objectList.getColumnWidth(this.columnNames[n]);
        int n4 = this.getFontMetrics(this.getFont()).charWidth('m') * n3 + 5;
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n4 > n2 ? n4 : n2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this._externalSelected) {
            this._externalSelected = false;
            return;
        }
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        this._internalSelected = true;
        this.objectList.setSelectionIndex(n);
    }

    @Override
    public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
        if (this._internalSelected) {
            this._internalSelected = false;
            return;
        }
        int n = dBListSelectionEvent.getSelectedRowIndex();
        if (n == -1) {
            return;
        }
        this.selectRow(n);
    }

    void selectRow(int n) {
        this._externalSelected = true;
        this.table.addRowSelectionInterval(n, n);
        this._externalSelected = false;
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        this._adjustScrollBar = true;
    }
}

