/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import java.text.DateFormat;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import pervasive.database.ColumnDef;
import pervasive.database.Row;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListModelListener;
import pvideoj.model.DBObjectList;

public class ListTableModelAdapter
extends AbstractTableModel
implements DBListModelListener {
    private static Class[] _btrClasses = new Class[]{String.class, Long.class, Double.class, String.class, String.class, Double.class, Double.class, Boolean.class, Double.class, Double.class, String.class, String.class, String.class, String.class, Long.class, Long.class, Byte.class, Double.class, Double.class, Double.class};
    private String[] _columnHeadings;
    private String[] _columnNames;
    private DBObjectList _list;
    private ColumnDef[] _columnDefs;

    public ListTableModelAdapter(DBObjectList dBObjectList) {
        this(dBObjectList, null, null);
    }

    public ListTableModelAdapter(DBObjectList dBObjectList, String[] stringArray, String[] stringArray2) {
        this._list = dBObjectList;
        this._list.addDBListModelListener(this);
        if (stringArray2 == null) {
            stringArray2 = this._list.getColumnNames();
        }
        this._columnNames = stringArray2;
        if (stringArray == null) {
            stringArray = this._columnNames;
        }
        this._columnHeadings = stringArray;
        this._columnDefs = new ColumnDef[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null) continue;
            this._columnDefs[i] = this._list.getColumnDef(stringArray2[i]);
        }
    }

    public DBObjectList getList() {
        return this._list;
    }

    @Override
    public int getRowCount() {
        return this._list.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._columnHeadings.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Row row = this._list.getRowFromIndex(n);
        if (row == null) {
            return null;
        }
        String string = this._columnDefs[n2].getColumnName();
        int n3 = this._columnDefs[n2].getType();
        Object object = null;
        switch (n3) {
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                object = row.getString(string);
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                object = new Long(row.getLong(string));
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: {
                object = new Double(row.getDouble(string));
                break;
            }
            case 7: {
                object = new Boolean(row.getBoolean(string));
                break;
            }
            case 3: {
                object = DateFormat.getDateInstance(3).format(row.getDate(string));
                break;
            }
            case 4: {
                object = DateFormat.getTimeInstance(3).format(row.getDate(string));
                break;
            }
            case 13: {
                object = new String();
                break;
            }
            case 16: {
                object = new Byte(row.getBytes(string)[0]);
            }
        }
        return object;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnHeadings[n];
    }

    public Class getColumnClass(int n) {
        return _btrClasses[this._columnDefs[n].getType()];
    }

    @Override
    public void listChanged(DBListModelEvent dBListModelEvent) {
        int n = dBListModelEvent.getType();
        if (n == 2) {
            this.fireTableChanged(new TableModelEvent(this, dBListModelEvent.getRow()));
        } else {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

