/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import pervasive.database.Database;
import pervasive.database.Index;
import pervasive.database.PsqlException;
import pervasive.database.PsqlOperationException;
import pervasive.database.Row;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObject;
import pvideoj.model.DBObjectList;
import pvideoj.model.Restriction;
import pvideoj.model.Title;
import pvideoj.model.TitleCopy;
import pvideoj.model.TitleList;

public class TitleCopyList
extends DBObjectList
implements DBListSelectionListener {
    private boolean _titleSelected = false;
    private TitleList _titles;
    private static String[] _statusStrs = new String[]{"Available", "Checked-out", "Overdue", "Missing", "Out of Service (getting fixed)", "Broken (not repairable)"};

    TitleCopyList(Database database) throws PsqlException {
        super(database, "Copies");
    }

    public TitleCopy createTitleCopy(Row row) {
        return new TitleCopy(this, row);
    }

    public TitleCopy createTitleCopy() {
        return new TitleCopy(this);
    }

    public void setRestrictOnSelectedTitle(TitleList titleList) {
        this._titles = titleList;
        this._titles.addDBListSelectionListener(this);
    }

    public TitleCopy findTitleCopyByIndex(int n, int n2) throws PsqlException {
        Row row;
        block2: {
            Index index = this._rowset.createIndex(0);
            this._rowsetMD.setAccessPath(0);
            index.setInt(0, n);
            index.setInt(1, n2);
            row = null;
            try {
                row = this._rowset.getByIndex(1, index);
            }
            catch (PsqlOperationException psqlOperationException) {
                if (psqlOperationException.getErrorCode() == 4) break block2;
                throw psqlOperationException;
            }
        }
        return row == null ? null : this.createTitleCopy(row);
    }

    public String[] getStatusStrs() {
        return _statusStrs;
    }

    public String getStatusStr(int n) {
        return _statusStrs[n];
    }

    public int getStatus(String string) {
        for (int i = 0; i < _statusStrs.length; ++i) {
            if (!string.equals(_statusStrs[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this._titles != null && !this._titleSelected) {
            return 0;
        }
        return super.getRowCount();
    }

    @Override
    public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
        if (!(dBListSelectionEvent.getSource() instanceof TitleList)) {
            return;
        }
        DBObject dBObject = dBListSelectionEvent.getSelectedObject();
        if (dBObject == null) {
            this._titleSelected = false;
            return;
        }
        this._titleSelected = true;
        this.setRestriction(new Restriction(0, 1, String.valueOf(((Title)dBObject).getID())));
    }

    @Override
    protected DBObject createObjectFromRow(Row row) {
        return new TitleCopy(this, row);
    }
}

