/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pervasive.database.PsqlException;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.Customer;
import pvideoj.model.CustomerList;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListModelListener;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.PVideoDB;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.CardPanel;
import pvideoj.views.NamePanel;
import pvideoj.views.PhonePanel;
import pvideoj.views.StatusPanel;

class CustomerInfoView
extends JPanel {
    private CardPanel _cardPanel;
    private PhonePanel _phonePanel;
    private NamePanel _namePanel;
    private StatusPanel _statusPanel;
    private ContractList _contracts;
    private CustomerList _customers;
    private CustomerList _sharedCustomers;
    private Customer _customer;

    CustomerInfoView(ContractList contractList, CustomerList customerList) {
        this._contracts = contractList;
        this._customers = customerList;
        this.setBorder(new TitledBorder(new EtchedBorder(), "Customer"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._cardPanel = new CardPanel("Card Information", this._customers);
        LayoutUtils.constrain(gridBagConstraints, this, this._cardPanel, 0, 0, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._cardPanel);
        this._namePanel = new NamePanel("Name");
        LayoutUtils.constrain(gridBagConstraints, this, this._namePanel, 1, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(this._namePanel);
        this._namePanel.setEditable(false);
        this._phonePanel = new PhonePanel("Phone");
        LayoutUtils.constrain(gridBagConstraints, this, this._phonePanel, 0, 1, 2, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._phonePanel);
        this._phonePanel.setEditable(false);
        this._statusPanel = new StatusPanel("Status");
        LayoutUtils.constrain(gridBagConstraints, this, this._statusPanel, 0, 2, 2, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._statusPanel);
        this._statusPanel.setEditable(false);
        this._contracts.addDBListSelectionListener(new ContractSelectionListener());
        this._customers.addDBListSelectionListener(new CustomerSelectionListener());
        try {
            this._sharedCustomers = (CustomerList)PVideoDB.instance().getSharedDBObjectList(3);
        }
        catch (PsqlException psqlException) {
            ErrorMessage.showMessage((Component)this, (Exception)((Object)psqlException));
            return;
        }
        this._sharedCustomers.addDBListModelListener(new DBListModelListener(){

            @Override
            public void listChanged(DBListModelEvent dBListModelEvent) {
                Customer customer;
                if (CustomerInfoView.this._customer == null || CustomerInfoView.this._customer.getID() == 0) {
                    return;
                }
                if (dBListModelEvent.getType() == 2 && (customer = (Customer)CustomerInfoView.this._sharedCustomers.getSelectedObject()).getID() == CustomerInfoView.this._customer.getID()) {
                    CustomerInfoView.this.setCustomer(customer);
                }
            }
        });
    }

    public void setCustomer(Customer customer) {
        this._customer = customer;
        this._cardPanel.setCardNumber(this._customer.getID());
        this._phonePanel.setHomePhone(this._customer.getHomePhone());
        this._phonePanel.setWorkPhone(this._customer.getWorkPhone());
        this._namePanel.setFirstName(this._customer.getFirstName());
        this._namePanel.setLastName(this._customer.getLastName());
        this._statusPanel.setStatus(this._customer.getStatus());
        this._statusPanel.setClubMember(this._customer.isMember());
        this._statusPanel.setExpiration(this._customer.getExpiration());
        this._cardPanel.setEditable(this._contracts.getSelectedObject() == null);
    }

    public boolean isValidInput() {
        return this._cardPanel.isValidInput();
    }

    public Customer getCustomer() {
        this._customer.setID(this._cardPanel.getCardNumber());
        return this._customer;
    }

    class ContractSelectionListener
    implements DBListSelectionListener {
        ContractSelectionListener() {
        }

        @Override
        public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
            Contract contract = (Contract)dBListSelectionEvent.getSelectedObject();
            if (contract == null) {
                CustomerInfoView.this.setCustomer(CustomerInfoView.this._customers.createCustomer());
                return;
            }
            try {
                Customer customer = CustomerInfoView.this._customers.findCustomer(contract.getCustomerID());
                if (customer == null) {
                    ErrorMessage.showMessage((Component)CustomerInfoView.this, "Customer \"" + contract.getCustomerID() + "\" not found.");
                    return;
                }
                CustomerInfoView.this.setCustomer(customer);
            }
            catch (PsqlException psqlException) {
                ErrorMessage.showMessage((Component)CustomerInfoView.this, (Exception)((Object)psqlException));
            }
        }
    }

    class CustomerSelectionListener
    implements DBListSelectionListener {
        CustomerSelectionListener() {
        }

        @Override
        public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
            Customer customer = (Customer)dBListSelectionEvent.getSelectedObject();
            if (customer != null) {
                CustomerInfoView.this.setCustomer(customer);
            }
        }
    }
}

