/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAConstants;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.ParamDesc;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public final class ColumnInfo
extends ParamDesc {
    private static byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private int d_displaySize;
    private int d_length;
    private int d_attributes;
    private String d_columnLabel;
    private String d_columnName;
    private String d_tableName;
    private String d_ownerName;
    private String d_qualifierName;
    private boolean d_checkForUTF8Encoding;

    public ColumnInfo() {
    }

    ColumnInfo(short s, int n, short s2, short s3, int n2, int n3, int n4, String string, String string2, String string3, String string4, String string5) {
        this.d_sqlDataType = s;
        this.d_precision = n;
        this.d_scale = s2;
        this.d_nullable = s3;
        this.d_displaySize = n2;
        this.d_length = n3;
        this.d_attributes = n4;
        this.d_columnLabel = string;
        this.d_columnName = string2;
        this.d_tableName = string3;
        this.d_ownerName = string4;
        this.d_qualifierName = string5;
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_displaySize = lNAResponse.readInt();
        this.d_length = lNAResponse.readInt();
        this.d_attributes = lNAResponse.readInt();
        this.d_sqlDataType = lNAResponse.readShort();
        this.d_precision = lNAResponse.readInt();
        this.d_scale = lNAResponse.readShort();
        this.d_nullable = lNAResponse.readShort();
        this.d_columnLabel = lNAResponse.readString(lNAResponse.getEncoding());
        this.d_columnName = lNAResponse.readString(lNAResponse.getEncoding());
        this.d_tableName = lNAResponse.readString(lNAResponse.getEncoding());
        this.d_ownerName = lNAResponse.readString(lNAResponse.getEncoding());
        this.d_qualifierName = lNAResponse.readString(lNAResponse.getEncoding());
        this.selectBinding();
    }

    public void writeBindingTo(LNARequest lNARequest) throws IOException {
        lNARequest.writeShort(this.d_cDataType);
        lNARequest.writeInt(this.d_maxSize);
        lNARequest.writeShort(this.d_maxSize == 0 ? 1 : 0);
    }

    public Object readValueFrom(LNAResponse lNAResponse) throws IOException {
        if (this.d_maxSize <= 0) {
            return null;
        }
        int n = lNAResponse.readInt();
        if (n == -1 || n == -95) {
            return null;
        }
        switch (this.d_cDataType) {
            case 1: {
                byte[] byArray = lNAResponse.readBytes(n);
                String string = this.convertToString(byArray, lNAResponse.getEncoding());
                Object object = string;
                switch (this.d_sqlDataType) {
                    case 2: 
                    case 3: {
                        object = new BigDecimal(string).setScale((int)this.d_scale, 2);
                        break;
                    }
                }
                return object;
            }
            case -8: {
                String string;
                byte[] byArray = lNAResponse.readBytes(n);
                String string2 = string = new String(byArray, "UTF-16LE");
                return string2;
            }
            case -25: {
                return new Long(lNAResponse.readLong());
            }
            case -27: {
                return lNAResponse.readUnsignedLong();
            }
            case -16: 
            case 4: {
                return new Integer(n == 2 ? lNAResponse.readShort() : lNAResponse.readInt());
            }
            case -18: {
                return new Long(lNAResponse.readUnsignedInt());
            }
            case -15: 
            case 5: {
                return new Short(lNAResponse.readShort());
            }
            case -17: {
                return new Integer(lNAResponse.readUnsignedShort());
            }
            case 7: {
                return new Float(lNAResponse.readFloat());
            }
            case 8: {
                return new Double(lNAResponse.readDouble());
            }
            case 9: {
                return lNAResponse.readDate();
            }
            case 10: {
                return lNAResponse.readTime();
            }
            case 11: {
                return lNAResponse.readTimestamp(this.d_precision, this.d_scale);
            }
            case -2: {
                return lNAResponse.readBytes(n);
            }
            case -7: {
                return new Boolean(lNAResponse.readShort() != 0);
            }
            case -26: 
            case -6: {
                return new Byte(lNAResponse.readByte());
            }
            case -28: {
                return new Short((short)lNAResponse.readUnsignedByte());
            }
            case -11: {
                return lNAResponse.readGUID(n);
            }
        }
        throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
    }

    public void writeValueTo(LNARequest lNARequest, Object object) throws IOException {
        if (object != null && this.d_cDataType == 1 && (this.d_sqlDataType == 2 || this.d_sqlDataType == 3)) {
            object = object instanceof Boolean ? ((Boolean)object == true ? "1" : "0") : object.toString();
        }
        if (object == null) {
            lNARequest.writeInt(-1);
            return;
        }
        if (this.d_maxSize <= 0) {
            lNARequest.writeInt(LNAConstants.SQL_LEN_DATA_AT_EXEC(24576));
            return;
        }
        int n = 0;
        switch (this.d_cDataType) {
            case 1: {
                if (object instanceof Boolean) {
                    object = (Boolean)object == true ? "1" : "0";
                } else if (object instanceof Number || object instanceof java.util.Date) {
                    object = object.toString();
                }
                if (object instanceof String) {
                    lNARequest.writeString((String)object);
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -8: {
                if (object instanceof String) {
                    lNARequest.writeString((String)object, "UTF-16LE");
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -27: 
            case -25: {
                lNARequest.writeInt(8);
                if (object instanceof Boolean) {
                    lNARequest.writeLong((Boolean)object == true ? 1L : 0L);
                    break;
                }
                lNARequest.writeLong(((Number)object).longValue());
                break;
            }
            case -18: 
            case -16: 
            case 4: {
                lNARequest.writeInt(4);
                if (object instanceof Boolean) {
                    lNARequest.writeInt((Boolean)object == true ? 1 : 0);
                    break;
                }
                lNARequest.writeInt(((Number)object).intValue());
                break;
            }
            case -17: 
            case -15: 
            case 5: {
                lNARequest.writeInt(2);
                if (object instanceof Boolean) {
                    lNARequest.writeShort((Boolean)object == true ? 1 : 0);
                    break;
                }
                lNARequest.writeShort(((Number)object).shortValue());
                break;
            }
            case 7: {
                lNARequest.writeInt(4);
                if (object instanceof Boolean) {
                    lNARequest.writeFloat((Boolean)object == true ? 1.0f : 0.0f);
                    break;
                }
                lNARequest.writeFloat(((Number)object).floatValue());
                break;
            }
            case 8: {
                lNARequest.writeInt(8);
                if (object instanceof Boolean) {
                    lNARequest.writeDouble((Boolean)object == true ? 1.0 : 0.0);
                    break;
                }
                lNARequest.writeDouble(((Number)object).doubleValue());
                break;
            }
            case 9: {
                lNARequest.writeInt(6);
                lNARequest.writeDate((Date)object);
                break;
            }
            case 10: {
                lNARequest.writeInt(6);
                lNARequest.writeTime((Time)object);
                break;
            }
            case 11: {
                lNARequest.writeInt(16);
                lNARequest.writeTimestamp((Timestamp)object);
                break;
            }
            case -2: {
                if (object instanceof byte[]) {
                    n = ((byte[])object).length;
                    if (n <= 0) break;
                    if (n >= this.d_maxSize) {
                        lNARequest.writeBytes((byte[])object, this.d_maxSize);
                        break;
                    }
                    lNARequest.writeBytes((byte[])object);
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -7: {
                lNARequest.writeInt(1);
                lNARequest.writeShort((Boolean)object == true ? 1 : 0);
                break;
            }
            case -28: 
            case -26: 
            case -6: {
                lNARequest.writeInt(1);
                lNARequest.writeByte(((Number)object).byteValue());
                break;
            }
            case -11: {
                lNARequest.writeInt(16);
                lNARequest.writeGUID(object.toString());
                break;
            }
            default: {
                throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
            }
        }
    }

    public int getDisplaySize() {
        return this.d_displaySize;
    }

    public int getLength() {
        return this.d_length;
    }

    public int getAttributes() {
        return this.d_attributes;
    }

    public String getColumnLabel() {
        return this.d_columnLabel;
    }

    public void setColumnLabel(String string) {
        this.d_columnLabel = string;
    }

    public String getColumnName() {
        return this.d_columnName;
    }

    public void setColumnName(String string) {
        this.d_columnName = string;
    }

    public void setColumnTags(String string) {
        this.d_columnName = string;
        this.d_columnLabel = string;
    }

    public String getTableName() {
        return this.d_tableName;
    }

    public String getColumnTypeName() {
        return this.d_ownerName;
    }

    public String getQualifierName() {
        return this.d_qualifierName;
    }

    public boolean hasLongData() {
        return this.d_maxSize == 0;
    }

    @Override
    public void selectBinding() {
        if ((this.d_attributes & 0x40) != 0) {
            super.selectBinding();
        } else {
            switch (this.d_sqlDataType) {
                case -5: {
                    this.d_cDataType = (short)-27;
                    this.d_maxSize = 8;
                    break;
                }
                case 4: {
                    this.d_cDataType = (short)-18;
                    this.d_maxSize = 4;
                    break;
                }
                case -6: 
                case 5: {
                    this.d_cDataType = (short)-17;
                    this.d_maxSize = 2;
                    break;
                }
                default: {
                    super.selectBinding();
                }
            }
        }
    }

    public void setCheckForUTF8Encoding() {
        this.d_checkForUTF8Encoding = true;
    }

    private String convertToString(byte[] byArray, String string) throws UnsupportedEncodingException {
        if (!this.d_checkForUTF8Encoding || byArray.length < 3) {
            return new String(byArray, string);
        }
        if (this.isUTF8BOM(Arrays.copyOfRange(byArray, 0, 3))) {
            return new String(Arrays.copyOfRange(byArray, 3, byArray.length), "UTF-8");
        }
        if (byArray.length >= 4 && byArray[0] == 39 && this.isUTF8BOM(Arrays.copyOfRange(byArray, 1, 4))) {
            byte[] byArray2 = new byte[byArray.length - 3];
            byArray2[0] = 39;
            System.arraycopy(byArray, 4, byArray2, 1, byArray.length - 4);
            return new String(byArray2, "UTF-8");
        }
        return new String(byArray, string);
    }

    private boolean isUTF8BOM(byte[] byArray) {
        return Arrays.equals(byArray, UTF8_BOM);
    }
}

